import pandas as pd
import numpy as np
import pickle
from decision_company import read_csv_file, check_elements_in_list, assert_series, logical_and, logical_or

atp_tennis = read_csv_file('atp_tennis.csv')

# Filter the dataset to only include grass court matches played by the top 10 players in the last five years
player_1_in_top_10 = check_elements_in_list(recent_matches['Player_1'], top_10_player_names)
player_2_in_top_10 = check_elements_in_list(recent_matches['Player_2'], top_10_player_names)
matches_with_top_10_players = logical_or(player_1_in_top_10, player_2_in_top_10)

matches_on_grass = assert_series(recent_matches['Surface'], 'Grass', 'equality')

grass_matches = recent_matches[logical_and(matches_on_grass, matches_with_top_10_players)]

print(grass_matches)
pickle.dump(grass_matches,open("./ref_result/grass_matches.pkl","wb"))